// MMIBrowserOutputDlg.cpp : Cve[V t@C
//OUTPUT^Õ_eBBrowserɊւNX

#include "stdafx.h"
#include "ib.h"
#include "MMIBrowserOutputDlg.h"
#include "IBFlowView.h"
#include "XISLOutputBrowser.h"
#include "XISLVar.h"
#include "XISLVarList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// CMMIBrowserOutputDlg _CAO


CMMIBrowserOutputDlg::CMMIBrowserOutputDlg(CXISLOutputBrowser *pOutputTag,CXISLTag *pCurrentTag,BOOL bNew,CWnd* pParent /*=NULL*/)
	: CDialog(CMMIBrowserOutputDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMMIBrowserOutputDlg)
	m_radioPositionGlp = -1;
	m_strURI = _T("");
	m_strWName = _T("");
	m_radioEventGlp = -1;
	m_strWindowID = _T("Main");
	m_nWidth = 0;
	m_nValue = 0;
	m_strString = _T("");
	m_nHeight = 0;
	m_bSize = FALSE;
	//}}AFX_DATA_INIT

	m_bNew = bNew;
	m_pOutputTag = pOutputTag;
	m_pCurrentTag = pCurrentTag;
	m_pParent = (CIBFlowView*)pParent;
	Create(CMMIBrowserOutputDlg::IDD,pParent);
}


void CMMIBrowserOutputDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMMIBrowserOutputDlg)
	DDX_Control(pDX, IDC_LIST_FORM, m_lbForm);
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Control(pDX, IDC_EDIT_W_NAME, m_editWName);
	DDX_Radio(pDX, IDC_RADIO_LTOP, m_radioPositionGlp);
	DDX_Text(pDX, IDC_EDIT_URI, m_strURI);
	DDX_Text(pDX, IDC_EDIT_W_NAME, m_strWName);
	DDX_Radio(pDX, IDC_RADIO_CREATE, m_radioEventGlp);
	DDX_Text(pDX, IDC_EDIT_WINDOWID, m_strWindowID);
	DDX_Text(pDX, IDC_EDIT_WIDTH, m_nWidth);
	DDV_MinMaxInt(pDX, m_nWidth, 0, 9999);
	DDX_Text(pDX, IDC_EDIT_VALUE, m_nValue);
	DDX_Text(pDX, IDC_EDIT_STRING, m_strString);
	DDX_Text(pDX, IDC_EDIT_HEIGHT, m_nHeight);
	DDV_MinMaxInt(pDX, m_nHeight, 0, 9999);
	DDX_Check(pDX, IDC_CHECK_SIZE, m_bSize);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMMIBrowserOutputDlg, CDialog)
	//{{AFX_MSG_MAP(CMMIBrowserOutputDlg)
	ON_BN_CLICKED(IDC_RADIO_MAXIMIZE, OnRadioMaximize)
	ON_BN_CLICKED(IDC_RADIO_MINIMIZE, OnRadioMinimize)
	ON_BN_CLICKED(IDC_RADIO_MOVE, OnRadioMove)
	ON_BN_CLICKED(IDC_RADIO_NAVIGATE, OnRadioNavigate)
	ON_BN_CLICKED(IDC_RADIO_CLOSE, OnRadioClose)
	ON_BN_CLICKED(IDC_CFILE_GET, OnCfileGet)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_VAR, OnDblclkListVar)
	ON_BN_CLICKED(IDC_RADIO_GET, OnRadioGet)
	ON_BN_CLICKED(IDC_RADIO_RELOAD, OnRadioReload)
	ON_BN_CLICKED(IDC_RADIO_RESIZE, OnRadioResize)
	ON_BN_CLICKED(IDC_RADIO_SET, OnRadioSet)
	ON_BN_CLICKED(IDC_RADIO_CREATE, OnRadioCreate)
	ON_BN_CLICKED(IDC_CHECK_SIZE, OnCheckSize)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LIST_FORM, OnKeydownListForm)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CMMIBrowserOutputDlg::InitDlgItem()
{
	GetDlgItem(IDC_CHECK_SIZE)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_URI)->EnableWindow(FALSE);
	GetDlgItem(IDC_CFILE_GET)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_W_NAME)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_WIDTH)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_HEIGHT)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_STRING)->EnableWindow(FALSE);
	GetDlgItem(IDC_EDIT_VALUE)->EnableWindow(FALSE);
	GetDlgItem(IDC_RADIO_LTOP)->EnableWindow(FALSE);
	GetDlgItem(IDC_RADIO_RTOP)->EnableWindow(FALSE);
	GetDlgItem(IDC_RADIO_CENTER)->EnableWindow(FALSE);
	GetDlgItem(IDC_RADIO_LBOTTOM)->EnableWindow(FALSE);
	GetDlgItem(IDC_RADIO_RBOTTOM)->EnableWindow(FALSE);
	m_lbVar.EnableWindow(FALSE);
	m_lbForm.EnableWindow(FALSE);
}

void CMMIBrowserOutputDlg::SetFormID(LPCTSTR lpszID,LPCTSTR lpszURI)
{
	UpdateData();
	//get,setȊÕCxĝƂ͖
	if(m_radioEventGlp != 8 && m_radioEventGlp != 9)
		return;

	LVFINDINFOA lvfind;
	lvfind.flags = LVFI_STRING;
	lvfind.psz = lpszID;
	if(m_lbForm.FindItem(&lvfind) != -1)
		return;

	CString strID = lpszID;
	LVITEMA item;
	item.mask = LVIF_TEXT;
	item.iItem = m_lbForm.GetItemCount();
	item.iSubItem = 0;
	item.pszText = strID.GetBuffer(strID.GetLength());

	m_lbForm.InsertItem(&item);
	strID.ReleaseBuffer();
}

BOOL CMMIBrowserOutputDlg::CreateFormMap(CMapStringToPtr *pSPMapForm)
{
	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_STATE;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;

	CString strValue;
	CString strID;
	CXISLVar *pVar=NULL;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	int nCount = m_lbForm.GetItemCount();
	for(int i=0;i<nCount; i++)
	{
		item.iItem = i;
		item.iSubItem = 0;
		m_lbForm.GetItem(&item);
		strID = item.pszText;
		item.iSubItem = 1;
		m_lbForm.GetItem(&item);
		strValue = item.pszText;

		if(strValue[0] == '\'' || isdigit(strValue[0]))
		{
			pVar = new CXISLVar;
			pVar->SetAttribute(strValue,"",FALSE,TRUE);
		}
		else
		{
			pVar = pExcItem->m_pLocalVar->FindVarWithParent(strValue);
			if(pVar==NULL)
			{
				pVar = new CXISLVar;
				if(pVar->SetAttribute(strValue,"",FALSE,FALSE) != 0)
				{
					delete pVar; pVar = NULL;
					return FALSE;
				}
				if(pExcItem->m_pLocalVar->RegistVar(pVar) != 0)
				{
					delete pVar; pVar = NULL;
					return FALSE;
				}
			}
		}
		pSPMapForm->SetAt(strID,(void*)pVar);
	}
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMMIBrowserOutputDlg bZ[W nh

void CMMIBrowserOutputDlg::PostNcDestroy() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	m_pParent->m_bDropOK = TRUE;
	m_pParent->m_pMODlg = NULL;
	delete this;
	//CDialog::PostNcDestroy();
}

void CMMIBrowserOutputDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	if(m_bNew)
	{
		delete m_pOutputTag;
		m_pOutputTag = NULL;
	}

	m_pParent->ResetViewItem();
	DestroyWindow();
//	CDialog::OnCancel();
}

void CMMIBrowserOutputDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();
	int nEvent;
	int nParam1=0,nParam2=0,nParam3=0;
	switch(m_radioEventGlp)
	{
	case 0:
		if(m_strWName.Compare("Main") == 0)
		{
			AfxMessageBox("Main͊ɃEBhEIDƂĎgpĂ܂D");
			return;
		}
		m_strWindowID = m_strWName;
	case 1:
		if(m_strURI.IsEmpty())
		{
			AfxMessageBox("ǂݍރt@Cw肵Ă");
			return;
		}
		((CIBApp*)AfxGetApp())->CreateBrowser(m_strWindowID,m_strURI);
		nEvent = ID_BROWSEREVENT_NAVI;
		if(m_bSize)
		{
			nParam1 = m_nWidth;
			nParam2 = m_nHeight;
			nParam3 = m_radioPositionGlp;
		}
		break;
	case 2:
		nEvent = ID_BROWSEREVENT_RESIZE;
		nParam1 = m_nWidth;
		nParam2 = m_nHeight;
		break;
	case 3:
		nEvent = ID_BROWSEREVENT_MOVE;
		nParam3 = m_radioPositionGlp;
		break;
	case 4:
		nEvent = ID_BROWSEREVENT_MAX;
		break;
	case 5:
		nEvent = ID_BROWSEREVENT_MIN;
		break;
	case 6:
		nEvent = ID_BROWSEREVENT_RELOAD;
		break;
	case 7:
		nEvent = ID_BROWSEREVENT_CLOSE;
		break;
	case 8:
		nEvent = ID_BROWSEREVENT_SET;
		break;
	case 9:
		nEvent = ID_BROWSEREVENT_GET;
		break;
	}

	if(m_pOutputTag->SetAttribute(nEvent,m_strURI,m_strWindowID,nParam1,nParam2,nParam3,m_bSize))
	{
		if(nEvent == ID_BROWSEREVENT_SET || nEvent == ID_BROWSEREVENT_GET)
		{
			CMapStringToPtr spMapForm;
			if(CreateFormMap(&spMapForm))
				m_pOutputTag->SetFormMap(&spMapForm);
			else
			{
				CString strID;
				CXISLVar *pVar=NULL;
				POSITION pos = spMapForm.GetStartPosition();
				while(pos)
				{
					spMapForm.GetNextAssoc(pos,strID,(void*&)pVar);
					spMapForm.RemoveKey(strID);
					if(pVar->IsDummy())
					{
						delete pVar;
						pVar = NULL;
					}
				}
			}
		}

		if(m_bNew)
			m_pParent->InsertOutputBrowser();
		else
		{
			CXISLDoc *pDoc = (CXISLDoc*)m_pParent->GetDocument();
			pDoc->UpdateAllViews(NULL,ID_VIEW_XISL|ID_VIEW_FLOW);
			DestroyWindow();
		}
	}

	return;
//	CDialog::OnOK();
}

void CMMIBrowserOutputDlg::OnCfileGet() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CFileDialog fileDlg(TRUE,"","",OFN_OVERWRITEPROMPT,
		"Rect@C(*.xml;*.html;*.xhtml)|*.xml;*.html;*.xhtml|");

	if(fileDlg.DoModal() == IDOK)
	{
		m_strURI = "file:///";
		CString str = fileDlg.GetPathName();
		str.Replace("\\","/");
		m_strURI += str;
		UpdateData(FALSE);
	}
}

void CMMIBrowserOutputDlg::OnDblclkListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = pNMListView->iItem;
	item.iSubItem = 0;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	if(item.iItem != -1)
	{
		int nIndex = m_lbForm.GetNextItem(-1,LVNI_SELECTED);
		if(nIndex != -1)
		{
			CString strValue;
			CXISLVar *pVar = (CXISLVar*)item.lParam;
			pVar->GetVarNameEx(strValue);

			LVITEMA itemForm;
			itemForm.mask = LVIF_TEXT;
			itemForm.iItem = nIndex;
			itemForm.iSubItem = 1;
			itemForm.pszText = strValue.GetBuffer(strValue.GetLength());

			m_lbForm.SetItem(&itemForm);
		}
	}
	*pResult = 0;
}

BOOL CMMIBrowserOutputDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		CWnd *pWnd = GetFocus();
		CString strTemp;
		int nIndex;
        switch( pMsg->wParam )
        {
        case VK_RETURN:   // Enter
			UpdateData();
			if(pWnd->GetDlgCtrlID() == IDC_EDIT_STRING)
			{
				strTemp = "'" + m_strString;
				strTemp += "'";
			}
			else if(pWnd->GetDlgCtrlID() == IDC_EDIT_VALUE)
				strTemp.Format("%d",m_nValue);

			 nIndex = m_lbForm.GetNextItem(-1,LVNI_SELECTED);
			if(nIndex != -1)
			{
				LVITEMA itemForm;
				itemForm.mask = LVIF_TEXT;
				itemForm.iItem = nIndex;
				itemForm.iSubItem = 1;
				itemForm.pszText = strTemp.GetBuffer(strTemp.GetLength());

				m_lbForm.SetItem(&itemForm);
			}
			return TRUE;
        default:
			break;
        }
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BOOL CMMIBrowserOutputDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	m_lbForm.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbVar.GetClientRect(&rect);
	column.cx = 70;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = (rect.right-rect.left)-70;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	int nType = m_pCurrentTag->m_nTagType;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pCurrentTag->GetParentExcTag();
	int nCount = pExcItem->m_pLocalVar->SetVar2ListBox(m_lbVar);
	
	CXISLDialogTag *pDTag = (CXISLDialogTag*)pExcItem->GetParentDialogTag();
	nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
	CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
	nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
	if(!pRTag->IsAppRoot() && g_pAppRootTag)
		g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);

	m_lbForm.GetClientRect(&rect);
	column.cx = (rect.right-rect.left)-100;
	column.pszText = "Form ID";
	m_lbForm.InsertColumn(0,&column);

	column.cx = 100;
	column.pszText = "ϐ or l";
	m_lbForm.InsertColumn(1,&column);

	InitDlgItem();
	
	m_strWindowID = m_pOutputTag->GetWindowName();
	switch(m_pOutputTag->m_nOutputEvent)
	{
	case ID_BROWSEREVENT_NAVI:
		m_strURI = m_pOutputTag->GetURI();
		m_bSize = m_pOutputTag->IsSizeChange();
		if(m_bSize)
		{
			m_nHeight = m_pOutputTag->GetHeight();
			m_nWidth = m_pOutputTag->GetWidth();
			m_radioPositionGlp = m_pOutputTag->GetPosition();
		}
		if(m_strWindowID.Compare("Main") != 0)
		{
			m_radioEventGlp = 0;
			UpdateData(FALSE);
			OnRadioCreate();
		}
		else
		{
			m_radioEventGlp = 1;
			UpdateData(FALSE);
			OnRadioNavigate();
		}
		break;
	case ID_BROWSEREVENT_RESIZE:
		m_radioEventGlp = 2;
		m_nHeight = m_pOutputTag->GetHeight();
		m_nWidth = m_pOutputTag->GetWidth();
		UpdateData(FALSE);
		OnRadioResize();
		break;
	case ID_BROWSEREVENT_MOVE:
		m_radioEventGlp = 3;
		m_radioPositionGlp = m_pOutputTag->GetPosition();
		UpdateData(FALSE);
		OnRadioMove();
		break;
	case ID_BROWSEREVENT_MAX:
		m_radioEventGlp = 4;
		UpdateData(FALSE);
		OnRadioMaximize();
		break;
	case ID_BROWSEREVENT_MIN:
		m_radioEventGlp = 5;
		UpdateData(FALSE);
		OnRadioMinimize();
		break;
	case ID_BROWSEREVENT_RELOAD:
		m_radioEventGlp = 6;
		UpdateData(FALSE);
		OnRadioReload();
		break;
	case ID_BROWSEREVENT_CLOSE:
		m_radioEventGlp = 7;
		UpdateData(FALSE);
		OnRadioClose();
		break;
	case ID_BROWSEREVENT_GET:
		m_radioEventGlp = 9;
		m_pOutputTag->GetForm2ListBox(m_lbForm);
		UpdateData(FALSE);
		InitDlgItem();
		m_lbVar.EnableWindow();
		m_lbForm.EnableWindow();
		break;
	case ID_BROWSEREVENT_SET:
		m_radioEventGlp = 8;
		m_pOutputTag->GetForm2ListBox(m_lbForm);
		UpdateData(FALSE);
		InitDlgItem();
		GetDlgItem(IDC_EDIT_STRING)->EnableWindow();
		GetDlgItem(IDC_EDIT_VALUE)->EnableWindow();
		m_lbVar.EnableWindow();
		m_lbForm.EnableWindow();
		break;
	}
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CMMIBrowserOutputDlg::OnRadioGet() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	m_lbVar.EnableWindow();
	m_lbForm.EnableWindow();
	m_lbForm.DeleteAllItems();
}

void CMMIBrowserOutputDlg::OnRadioReload() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
}

void CMMIBrowserOutputDlg::OnRadioResize() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_EDIT_WIDTH)->EnableWindow();
	GetDlgItem(IDC_EDIT_HEIGHT)->EnableWindow();
}

void CMMIBrowserOutputDlg::OnRadioSet() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_EDIT_STRING)->EnableWindow();
	GetDlgItem(IDC_EDIT_VALUE)->EnableWindow();
	m_lbVar.EnableWindow();
	m_lbForm.EnableWindow();
	m_lbForm.DeleteAllItems();
}

void CMMIBrowserOutputDlg::OnRadioMaximize() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
}

void CMMIBrowserOutputDlg::OnRadioMinimize() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
}

void CMMIBrowserOutputDlg::OnRadioMove() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_RADIO_LTOP)->EnableWindow();
	GetDlgItem(IDC_RADIO_RTOP)->EnableWindow();
	GetDlgItem(IDC_RADIO_CENTER)->EnableWindow();
	GetDlgItem(IDC_RADIO_LBOTTOM)->EnableWindow();
	GetDlgItem(IDC_RADIO_RBOTTOM)->EnableWindow();
}

void CMMIBrowserOutputDlg::OnRadioNavigate() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	InitDlgItem();
	GetDlgItem(IDC_CHECK_SIZE)->EnableWindow();
	GetDlgItem(IDC_EDIT_URI)->EnableWindow();
	GetDlgItem(IDC_CFILE_GET)->EnableWindow();
	if(m_bSize)
	{
		GetDlgItem(IDC_EDIT_WIDTH)->EnableWindow();
		GetDlgItem(IDC_EDIT_HEIGHT)->EnableWindow();
		GetDlgItem(IDC_RADIO_LTOP)->EnableWindow();
		GetDlgItem(IDC_RADIO_RTOP)->EnableWindow();
		GetDlgItem(IDC_RADIO_CENTER)->EnableWindow();
		GetDlgItem(IDC_RADIO_LBOTTOM)->EnableWindow();
		GetDlgItem(IDC_RADIO_RBOTTOM)->EnableWindow();
	}
}

void CMMIBrowserOutputDlg::OnRadioClose() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
}


void CMMIBrowserOutputDlg::OnRadioCreate() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	InitDlgItem();
	GetDlgItem(IDC_EDIT_W_NAME)->EnableWindow();
	GetDlgItem(IDC_CHECK_SIZE)->EnableWindow();
	GetDlgItem(IDC_EDIT_URI)->EnableWindow();
	GetDlgItem(IDC_CFILE_GET)->EnableWindow();
	if(m_bSize)
	{
		GetDlgItem(IDC_EDIT_WIDTH)->EnableWindow();
		GetDlgItem(IDC_EDIT_HEIGHT)->EnableWindow();
		GetDlgItem(IDC_RADIO_LTOP)->EnableWindow();
		GetDlgItem(IDC_RADIO_RTOP)->EnableWindow();
		GetDlgItem(IDC_RADIO_CENTER)->EnableWindow();
		GetDlgItem(IDC_RADIO_LBOTTOM)->EnableWindow();
		GetDlgItem(IDC_RADIO_RBOTTOM)->EnableWindow();
	}
}

void CMMIBrowserOutputDlg::OnCheckSize() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	GetDlgItem(IDC_EDIT_WIDTH)->EnableWindow(m_bSize);
	GetDlgItem(IDC_EDIT_HEIGHT)->EnableWindow(m_bSize);
	GetDlgItem(IDC_RADIO_LTOP)->EnableWindow(m_bSize);
	GetDlgItem(IDC_RADIO_RTOP)->EnableWindow(m_bSize);
	GetDlgItem(IDC_RADIO_CENTER)->EnableWindow(m_bSize);
	GetDlgItem(IDC_RADIO_LBOTTOM)->EnableWindow(m_bSize);
	GetDlgItem(IDC_RADIO_RBOTTOM)->EnableWindow(m_bSize);
}

void CMMIBrowserOutputDlg::OnKeydownListForm(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	if(pLVKeyDow->wVKey == VK_DELETE)
	{
		int nIndex = m_lbForm.GetNextItem(-1,LVNI_SELECTED);
		if(nIndex != -1)
			m_lbForm.DeleteItem(nIndex);
	}
	*pResult = 0;
}
